var fontSize = 90;
jQuery(document).ready(function(){
	var theme = Drupal.settings.ncc.basepath + '/css/';
	console.log(theme);
	if(_getCookie("nccfontSize") != null){
		var fontSize = _getCookie("nccfontSize");
	}else{
		var fontSize = 90;
	}
	jQuery("body .main").css("font-size", fontSize + "%");
	if(_getCookie("ncctheme") != null){
		theme += _getCookie("ncctheme")+'.css';
	}
	else{
		theme += 'style.css';
	}
	var style = '<link type="text/css" rel="stylesheet" id="theme_css" media="all" href="'+theme+'" />';
	jQuery('head').append(style);
});
function _getCookie(name) {
	var arg = name + "=";
	var alen = arg.length;
	var clen = document.cookie.length;
	var i = 0;
	while (i < clen) {
		var j = i + alen;
		if (document.cookie.substring(i, j) == arg) {
			return _getCookieVal (j);
		}
		i = document.cookie.indexOf(" ", i) + 1;
		if (i == 0)
		break;
	}
	return null;
}
function _deleteCookie(name,path,domain) {
	if (_getCookie(name)) {
		document.cookie = name + "=" +
		((path) ? "; path=" + path : "") +
		((domain) ? "; domain=" + domain : "") +
		"; expires=Thu, 01-Jan-70 00:00:01 GMT";
	}
}
function _setCookie(name,value,expires,path,domain,secure) {
	var vurl = true;
	if(path != '' && path != undefined){
		vurl = validUrl(path);
	}
	if(jQuery.type(name) == "string" &&  vurl){
		document.cookie = name + "=" + escape (value) +
		((expires) ? "; expires=" + expires.toGMTString() : "") +
		((path) ? "; path=" + path : "") +
		((domain) ? "; domain=" + domain : "") +
		((secure) ? "; secure" : "");
	}
}
function _getCookieVal(offset) {
	var endstr = document.cookie.indexOf (";", offset);
	if (endstr == -1) { endstr = document.cookie.length; }
	return unescape(document.cookie.substring(offset, endstr));
}
/*********Font size resize**********/
function setFontSize(fontType){
	if(fontType == "plus"){
		if(fontSize < 100){
			fontSize = parseInt(fontSize) + 8;
		}
	}
	else if(fontType == "minus"){
		if(fontSize > 70){
			fontSize = parseInt(fontSize) - 15;
		}
	}
	else{
		fontSize = 90;
	}
	_setCookie("nccfontSize",fontSize);
	jQuery("body .main").css("font-size",fontSize + "%");
	//jQuery("#template_three_column").css("font-size",fontSize + "%");
}

/*********Font theme**********/
function setTheme(style){
	var theme = Drupal.settings.ncc.basepath + '/css/';
	if(style == "dark"){
		theme += 'dark.css';
		_setCookie("ncctheme", style);
	}
	else{
		theme += 'custom.css';
		_deleteCookie('ncctheme');
	}
	jQuery('head #theme_css').attr('href', theme);
}