$(document).ready(function() {
	
	$('#dataTables-example').DataTable( {
        dom: 'Bfrtip',
        buttons: [
            'excel'
        ]
    } );
	 
	var modal_div = document.getElementById('meta_content_popup_div');
	var modal_show = document.getElementById('add_btn_new');
	var modal_close = document.getElementsByClassName("close")[0];
	modal_close.onclick = function() {
		$('#content_div').html('');
		modal_div.style.display = "none";
	}
	modal_show.onclick = function() {
		$.ajax({
			url: HTTP_PATH+"home_page/call_div",
			success: function(msg) {
				$('#content_div').append(msg);
				$('#header_h4').text('Add New');
				modal_div.style.display = "block";
				check_type(1);
			}
		});		
	}
	
	window.onclick = function(event){
		if(event.target == modal_div){
			$('#content_div').html('');
			modal_div.style.display = "none";
		}
	}
	
	$(document).on('change','.check_text',function(){
		check_type($(this).val());
	});
		
});

function check_type(type){
		
	if(type==1){
		var file='<strong>Slider Image</strong><i class="span_star">*</i><span class="span_ms">(Best Size 1200px*700px)</span><input id="type_file" name="type_file" style="height:35px" type="file">'
		$('#type_div').html(file);
	}
	
	if(type==2){
		var txt='<strong>Slider Video Link</strong><i class="span_star">*</i><input id="video_link" name="video_link" class="form-control" placeholder="Video Link" type="text">';
		$('#type_div').html(txt);
	}
}



$(document).on('click', '#meta_submitBtn_cancel', function () {     
	var modal_div = document.getElementById('meta_content_popup_div');	
	$('#content_div').html('');
	modal_div.style.display = "none";
});

$(document).on('focus', 'input[type=text],textarea', function () {     
	$(this).removeClass('error_m');		
});

var _URL = window.URL || window.webkitURL;
$(document).on('change', '#type_file', function () {    
 
	var web_width=0; 
	var web_height=0;
	var file, img1;
	if ((file = this.files[0])) {
		img1 = new Image();
		img1.onload = function () {
			web_width=this.width;
			web_height=this.height;
			if(web_width<'1200' || web_width>'1250' || web_height<'700' || web_height>'725'){		 
				alert('Please image upload 1200*700');
				$('#type_file').val(null).clone(true);
			}
		};
		img1.src = _URL.createObjectURL(file);
	}
});
 
$(document).on('click', '#meta_submitBtn', function () {
	var error=false;
	$('#meta_content_popup_div').find('input[type=text],textarea').each(function () {
		$(this).removeClass('error_m');		
		if($(this).val()==""){	
			$(this).addClass('error_m');
			error=true;
		} 
    });
	if(error==true){
		return false;
	}else{
		document.getElementById("meta_submitBtn").disabled = true;
		$('#message_div').html(http_loader);
		var type=$("input[type='radio'][name='check_text']:checked").val();
		
		var formData = new FormData();
		
		formData.append('id',$('#update_id').val());
		formData.append('captions',$('#captions').val());	
		formData.append('slider_type',type);
		if(type==1){
			formData.append('type_file', $('#type_file')[0].files[0]);
		}
		if(type==2){
			formData.append('video_link', $('#video_link').val());
		}
		
		$.ajax({
			url: HTTP_PATH+"home_page/actions",
			data: formData,
			type: "POST",
			dataType : "JSON",
			processData: false,  // tell jQuery not to process the data
			contentType: false, 
			success: function(msg) {
				if(msg.success==true){
					$('#message_div').html(msg.text);
					setTimeout(function(){					
						document.location.href=HTTP_PATH+'home_page';
					},1000);
				}else{
					document.getElementById("meta_submitBtn").disabled = false;
					if(msg.img){
						$('#message_div').html(msg.img);
					}else{
						$('#message_div').html(msg.text);
					}
				}
			}
		});
	}
});


function update_home_slider(txt){
	var modal_div = document.getElementById('meta_content_popup_div');
	var image_=$('#row_'+txt).find("td").eq(0).html();
	var tpye_= $('#row_'+txt).find("td").eq(1).text().replace(/\s+/, "") ;
	var caption=$('#row_'+txt).find("td").eq(2).html();
	
	$('#header_h4').text('Edit');
	$.ajax({
		url: HTTP_PATH+"home_page/call_div",
		success: function(msg) {
			$('#content_div').append(msg);
			modal_div.style.display = "block";
			$('#update_id').val(txt);
			$('#captions').val(caption);			 
				
			if(tpye_=="Video"){
				$("input[type='radio'][name='check_text'][value=2]").prop("checked", true);
				check_type(2);
				$('#type_content').html(image_);
				$('#type_content img').css({width:'50%'});
				$('#video_link').val($('#type_content iframe').attr('src'));					
				
			}else if(tpye_=="Image"){
				$("input[type='radio'][name='check_text'][value=1]").prop("checked", true);
				check_type(1);
				$('#type_content').html(image_);
				$('#type_content img').css({width:'50%'});				
				 
			} 
		}
	});		
}

function delete_home_slider(txt){
	$.ajax({
		url: HTTP_PATH+"home_page/deletes",
		data: {deleteId: txt},
		type: "POST",
		dataType : "JSON", 
		success: function(msg) {
			if(msg.success==true){
				alert(msg.text);
				setTimeout(function(){					
					document.location.href=HTTP_PATH+'home_page';
				},2000);
			}else{
				alert(msg.text);				
			}
		}
	});
}

	 
/* 	$('#meta_content_popup_div').find('input[type=text],textarea').each(function () {
		$(this).removeClass('error_m');		
		if($(this).val()==""){	
			$(this).addClass('error_m');
			//$(this).after('<p class="error_m">data sds dsadf </p>');			 
		} 
     }); $('#row_2').find("td").eq(4).html()
*/