$(document).ready(function() {
 
	$('#dataTables-example').DataTable({
		responsive: true
	});
	 
	var modal_div = document.getElementById('meta_content_popup_div');
	var modal_show = document.getElementById('add_btn_new');
	var modal_close = document.getElementsByClassName("close")[0];
	modal_close.onclick = function() {
		$('#content_div').html('');
		modal_div.style.display = "none";
	}
	modal_show.onclick = function() {
		$.ajax({
			url: HTTP_PATH+"meta_content/call_div",
			success: function(msg) {
				$('#content_div').append(msg);
				$('#header_h4').text('Add Page Content');
				modal_div.style.display = "block";
			}
		});		
	}
	
	window.onclick = function(event) {
		if (event.target == modal_div) {
			$('#content_div').html('');
			modal_div.style.display = "none";
		}
	}
		
});

$(document).on('click', '#meta_submitBtn_cancel', function () {     
	var modal_div = document.getElementById('meta_content_popup_div');	
	$('#content_div').html('');
	modal_div.style.display = "none";
});

$(document).on('focus', 'input[type=text],textarea', function () {     
	$(this).removeClass('error_m');		
});

var _URL = window.URL || window.webkitURL;
$(document).on('change', '#page_file', function () {    
 
	var web_width=0; 
	var web_height=0;
	var file, img1;
	if ((file = this.files[0])) {
		img1 = new Image();
		img1.onload = function () {
			web_width=this.width;
			web_height=this.height;
			if(web_width<'1355' || web_width>'1365' || web_height<'215' || web_height>'225'){		 
				alert('Please image upload 1360px*220px');
				$('#page_file').val(null).clone(true);
			}
		};
		img1.src = _URL.createObjectURL(file);
	}
});
 
$(document).on('click', '#meta_submitBtn', function () {
	var error=false;
	$('#meta_content_popup_div').find('input[type=text],textarea').each(function () {
		$(this).removeClass('error_m');		
		if($(this).val()==""){	
			$(this).addClass('error_m');
						error=true;			
		} 
    });
	
	if(error==true){
		return false;
	}else{
		document.getElementById("meta_submitBtn").disabled = true;
		$('#message_div').html(http_loader);
		var formData = new FormData();
		formData.append('banner_file', $('#page_file')[0].files[0]);
		formData.append('id',$('#update_id').val());
		formData.append('slug',$('#page_slug').val());	
		formData.append('title',$('#page_title').val());
		formData.append('meta_title',$('#page_meta_title').val());
		formData.append('meta_description',$('#page_meta_description').val());
		formData.append('meta_keyword',$('#page_meta_keyword').val());
		$.ajax({
			url: HTTP_PATH+"meta_content/actions",
			data: formData,
			type: "POST",
			dataType : "JSON",
			processData: false,  // tell jQuery not to process the data
			contentType: false, 
			success: function(msg) {
				if(msg.success==true){
					$('#message_div').html(msg.text);
					setTimeout(function(){					
						document.location.href=HTTP_PATH+'meta-content';
					},1500);
				}else{
					document.getElementById("meta_submitBtn").disabled = false;
					if(msg.img){
						$('#message_div').html(msg.img);
					}else{
						$('#message_div').html(msg.text);
					}
				}
			}
		});
	}
});

function update_meta_content(txt){
	var modal_div = document.getElementById('meta_content_popup_div');
	var slug=$('#row_'+txt).find("td").eq(0).html();
	var title=$('#row_'+txt).find("td").eq(1).html();
	var image_t=$('#row_'+txt).find("td").eq(2).html();
	var meta_title=$('#row_'+txt).find("td").eq(3).html();
	var meta_description= $('#row_'+txt).find("td").eq(4).html();
	var meta_keyword=$('#row_'+txt).find("td").eq(5).html();
	$('#header_h4').text('Update Page Content');
	$.ajax({
		url: HTTP_PATH+"meta_content/call_div",
		success: function(msg) {
			$('#content_div').append(msg);
			modal_div.style.display = "block";
			$('#update_id').val(txt);
			$('#page_slug').val(slug);	
			$('#page_title').val(title);
			$('#page_meta_title').val(meta_title);
			$('#page_meta_description').val(meta_description);
			$('#page_meta_keyword').val(meta_keyword);
			$('#show_banner_img').html(image_t);
			$('#show_banner_img img').css({width:'100%'});
		}
	});		
}

function delete_meta_content(txt){
	$.ajax({
		url: HTTP_PATH+"meta_content/delete_meta",
		data: {deleteId: txt},
		type: "POST",
		dataType : "JSON", 
		success: function(msg) {
			if(msg.success==true){
				alert(msg.text);
				setTimeout(function(){					
					document.location.href=HTTP_PATH+'meta-content';
				},1000);
			}else{
				alert(msg.text);				
			}
		}
	});
}

	 
/* 	$('#meta_content_popup_div').find('input[type=text],textarea').each(function () {
		$(this).removeClass('error_m');		
		if($(this).val()==""){	
			$(this).addClass('error_m');
			//$(this).after('<p class="error_m">data sds dsadf </p>');			 
		} 
     }); $('#row_2').find("td").eq(4).html()
*/