<?php
defined('BASEPATH') OR exit('No direct script access allowed');
/*
Expert panel user story view
Author @deepak saini
*/


class Upload_excel extends CI_Controller {	 
	public function __construct() {
     parent::__construct();
		if($this->session->userdata('expert')['Logged_In']){
			$this->load->model('expert/Expert_model','model');
			 
		}else{
			redirect(BASE_EXPERT_URL);
		}		         
    }
	
	
	public function index(){		
		$data['stories'] = $this->model->get_story_list();
		//var_dump($data['stories']);die;
		$this->load->view('expert/includes/expert_header',$data);
		$this->load->view('expert/story_list_view');
		$this->load->view('expert/includes/expert_footer');
	}
	
	public function review(){		
		$data['stories'] = $this->model->get_story_list(1);
		//var_dump($data['stories']);die;
		$this->load->view('expert/includes/expert_header',$data);
		$this->load->view('expert/story_list_view');
		$this->load->view('expert/includes/expert_footer');
	}
	
	public function evaluated(){		
		$data['stories'] = $this->model->get_story_list(2);
		//var_dump($data['stories']);die;
		$this->load->view('expert/includes/expert_header',$data);
		$this->load->view('expert/story_list_view');
		$this->load->view('expert/includes/expert_footer');
	}
	
	public function details($id=""){
		if($id==""){
			redirect(BASE_EXPERT_URL);
		}
		
		$expId=$this->session->userdata('expert')['ExpertId'];
		$details=$this->model->get_story_mark_detail($expId, $id);
		if($details!=null){
			$data['details'] = $details;
			//var_dump($data['details']);die;
			$this->load->view('expert/includes/expert_header',$data);
			$this->load->view('expert/story_details_view');
			$this->load->view('expert/includes/expert_footer');
		}else{
			redirect(BASE_EXPERT_URL);
		}
	}
	/* SELECT `id`, `StoryId`, `ExpertId`, `IsExpert`, `Language_Type`, `Content_Type`, `Format_Type`, `Overall_Type`, `Language_Mark`, `Content_Mark`, `Format_Mark`, `Overall_Mark`, `TotalMarks`, `IsActive`, `CreatedDate`, `ModifiedDate` FROM `tblstory_marks` WHERE 1 */
	/* array(8) { ["language_mark"]=> string(1) "3" ["language_mark_drp"]=> string(2) "13" ["content_mark"]=> string(1) "3" ["content_mark_drp"]=> string(2) "13" ["format_mark"]=> string(1) "3" ["format_mark_drp"]=> string(2) "13" ["overall_mark"]=> string(1) "3" ["overall_mark_drp"]=> string(2) "25" }  */
	function action(){
	//	var_dump($this->input->post());die;
		if($this->session->userdata('expert')['Logged_In']){
			if($this->input->post()){
				$id = trim($this->input->post('StoryMarkId'));
				$expId = $this->session->userdata('expert')['ExpertId'];
				$details = $this->model->get_story_mark_detail($expId, $id);
				if($details!=null && $details->IsExpert==0){
					$totalMarks=trim($this->input->post('totalMarks'));
					if($totalMarks!="" || $totalMarks!=0){
						$markArray=array(
							'IsExpert' 			=> 1,
							'Language_Type' 	=> trim($this->input->post('language_mark')),
							'Content_Type' 		=> trim($this->input->post('content_mark')),
							'Format_Type' 		=> trim($this->input->post('format_mark')),
							'Overall_Type'		=> trim($this->input->post('overall_mark')),
							'Language_Mark' 	=> trim($this->input->post('language_mark_drp')),
							'Content_Mark' 		=> trim($this->input->post('content_mark_drp')),
							'Format_Mark' 		=> trim($this->input->post('format_mark_drp')),
							'Overall_Mark' 		=> trim($this->input->post('overall_mark_drp')),
							'TotalMarks' 		=> trim($this->input->post('totalMarks')),
							'ExpertRemarks'		=> trim($this->input->post('ExpertRemarks')),
							'ModifiedDate'		=> date('Y-m-d H:i:s')						
						);
						
						$this->db->where('id', $id);					 
						$this->db->update('tblstory_marks',$markArray);
					}
					redirect(BASE_EXPERT_URL .'articles/details/'.$id);
				}else{
					redirect(BASE_EXPERT_URL);
				}
				
			}else{
				redirect(BASE_EXPERT_URL);
			}
		}else{
			redirect(BASE_EXPERT_URL);
		}
	}
	
}